import { world } from '@minecraft/server';

export class Elephant {
	constructor() {
		this.identifier = 'sf_nba:elephant';

		this.onHurt();
	}

	/**
	 * Triggered when the elephant entity takes damage.
	 */
	onHurt() {
		world.afterEvents.entityHitEntity.subscribe((data) => {
			if (data.damagingEntity?.typeId === this.identifier) {
				let elephant = data.damagingEntity;
				let damaged = data.hitEntity;
				damaged.applyKnockback(damaged.location.x - elephant.location.x, damaged.location.z - elephant.location.z, 1.0, 1.0);
			} /* else if (data.hitEntity instanceof Player &&
			  data.damagingEntity?.typeId === 'sf_nba:vulture'
			) {
			  let player = data.hitEntity;
			  let vulture = data.damagingEntity;
			  let playerHand = player.getComponent('inventory').container;
			  let vultureHand = vulture.getComponent('equippable');
			  let playerItem = playerHand.getItem(player.selectedSlot);
			  playerItem.amount = 1;
			  vultureHand.setEquipment('Mainhand', playerItem);
			  naturalist.decrementStack(playerHand, player.selectedSlot);
			  world.playSound('random.pop', vulture.location, {volume: 0.25, pitch: ((Math.random() - Math.random()) * 0.7 + 1.0) * 2.0});
			} */
		});
	}
}

new Elephant();